/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.userinterface;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.UserInterfaceInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

/* Soap implementation for the UserInterface-Interface */
public class GetInfo extends UserInterfaceSoapHelper<UserInterfaceInfo>
{
	public GetInfo(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public UserInterfaceInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		UserInterfaceInfo uifInfo = new UserInterfaceInfo(); 
		uifInfo.setUpgradeAvailable(getBooleanByName("NewUpgradeAvailable", input));
		uifInfo.setPasswordRequired(getBooleanByName("NewPasswordRequired", input));
		uifInfo.setPasswordUserSelectable(getBooleanByName("NewPasswordUserSelectable", input));
		uifInfo.setWarrantyDate(getDateTimeByName("NewWarrantyDate", input));
		uifInfo.setVersion(getValueByName("NewX_AVM-DE_Version", input));
		uifInfo.setDownloadURL(getValueByName("NewX_AVM-DE_DownloadURL", input));
		uifInfo.setInfoURL(getValueByName("NewX_AVM-DE_InfoURL", input));
		uifInfo.setUpdateState(getValueByName("NewX_AVM-DE_UpdateState", input));
		uifInfo.setLaborVersion(getValueByName("NewX_AVM-DE_LaborVersion", input));
		
		return uifInfo;
	}

	@Override
	public String getSoapMethod()
	{
		return "GetInfo";
	}
}