/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on a TAM. As received from the Fritzbox 
 */
public class TamInfo implements Parcelable {
	/*
		NewIndex  In  Int  index in list (0 <= index < count) 
		NewName  Out  String  user friendly name 
		NewEnable  Out  Boolean  is TAM enabled? 
	*/

	private int mIndex;
	private String mName;
	private boolean mEnable = false;
	private boolean mDisplay = false;

	public TamInfo(int index)
	{
		mIndex = index;
	}

    public TamInfo() {}
	
	public int getIndex()
	{
		return mIndex;
	}
	
	public String getName()
	{
		return mName;
	}
	
	public void setName(String name)
	{
		mName = name;
	}

	public boolean isEnable()
	{
		return mEnable;
	}
	
	public void setEnable(boolean enable)
	{
		mEnable = enable;
	}

	public boolean isDisplay()
	{
		return mDisplay;
	}
	
	public void setDisplay(boolean display)
	{
		mDisplay = display;
	}



    @Override
    public String toString() {
        return "TamInfo{" +
                "mIndex=" + mIndex +
                ", mName='" + mName + '\'' +
                ", mEnable=" + mEnable +
                ", mDisplay=" + mDisplay +
                '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mIndex);
        dest.writeString(this.mName);
        dest.writeByte(mEnable ? (byte) 1 : (byte) 0);
        dest.writeByte(mDisplay ? (byte) 1 : (byte) 0);
    }

    private TamInfo(Parcel in) {
        this.mIndex = in.readInt();
        this.mName = in.readString();
        this.mEnable = in.readByte() != 0;
        this.mDisplay = in.readByte() != 0;
    }

    public static final Parcelable.Creator<TamInfo> CREATOR = new Parcelable.Creator<TamInfo>() {
        public TamInfo createFromParcel(Parcel source) {
            return new TamInfo(source);
        }

        public TamInfo[] newArray(int size) {
            return new TamInfo[size];
        }
    };
}