/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import java.util.ArrayList;


import android.os.Parcel;
import android.os.Parcelable;

/* Represents a contact in a phonebook */
public class Contact implements Parcelable
{
	protected int mCategory = 0;
	protected String mRealName = "";

	public static final int CATEGORY_WICHTIG = 1;

	protected ArrayList<ContactNumber> mNumbers = new ArrayList<ContactNumber>();
	protected ArrayList<ContactEmail> mEmails = new ArrayList<ContactEmail>();

	/**
	 * Instantiates a new contact.
	 */
	public Contact()
	{
		super();
	}
	
	/**
	 * Instantiates a new contact.
	 * 
	 * @param in
	 *            the in
	 */
	public Contact(Parcel in)
	{
		mCategory = in.readInt();
		mRealName = in.readString();
		in.readTypedList(mNumbers, ContactNumber.CREATOR);
		in.readTypedList(mEmails, ContactEmail.CREATOR);
	}

	/**
	 * Adds the number.
	 * 
	 * @param cn
	 *            the cn
	 */
	public void addNumber(ContactNumber cn)
	{
		mNumbers.add(cn);
	}

	/**
	 * Gets the contact numbers.
	 * 
	 * @return the contact numbers
	 */
	public ArrayList<ContactNumber> getContactNumbers()
	{
		return mNumbers;
	}

	/**
	 * Adds the email address.
	 * 
	 * @param email
	 *            the email
	 */
	public void addEmail(ContactEmail email)
	{
		mEmails.add(email);
	}

	/**
	 * Gets the contact email addresses.
	 * 
	 * @return the contact email addresses
	 */
	public ArrayList<ContactEmail> getContactEmails()
	{
		return mEmails;
	}

	/**
	 * Gets the category.
	 * 
	 * @return the category
	 */
	public int getCategory()
	{
		return mCategory;
	}

	/**
	 * Sets the category.
	 * 
	 * @param category
	 *            the new category
	 */
	public void setCategory(int category)
	{
		mCategory = category;
	}

	/**
	 * Gets the real name.
	 * 
	 * @return the real name
	 */
	public String getRealName()
	{
		return mRealName;
	}

	/**
	 * Sets the real name.
	 * 
	 * @param realName
	 *            the new real name
	 */
	public void setRealName(String realName)
	{
		mRealName = (realName == null) ? "" : realName;
	}

	/* (non-Javadoc)
	 * @see android.os.Parcelable#describeContents()
	 */
	public int describeContents()
	{
		return 0;
	}

	/* (non-Javadoc)
	 * @see android.os.Parcelable#writeToParcel(android.os.Parcel, int)
	 */
	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt(mCategory);
		out.writeString(mRealName);
		out.writeTypedList(mNumbers);
		out.writeTypedList(mEmails);
	}

	public static final Parcelable.Creator<Contact> CREATOR = new Parcelable.Creator<Contact>()
	{
		public Contact createFromParcel(Parcel in)
		{
			return new Contact(in);
		}

		public Contact[] newArray(int size)
		{
			return new Contact[size];
		}
	};
}