/* 
 * Copyright 2011 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import de.avm.android.fritzapp.R;
import de.avm.android.tr064.model.VoIPClientInfo;
import android.content.Context;
import android.preference.CheckBoxPreference;
import android.text.TextUtils;

public class VoIPClientListItem extends CheckBoxPreference
{
	public static final int ORDER_PREPEND = 1; 
	public static final int ORDER_NORMAL = 2; 
	public static final int ORDER_APPEND = 3; 
	
	private VoIPClientInfo mInfo;
	
	public VoIPClientInfo getInfo()
	{
		return mInfo;
	}

	public VoIPClientListItem(Context context, VoIPClientInfo info, boolean autoConf)
	{
		super(context);
		mInfo = info;

		setOrder((autoConf) ? ORDER_PREPEND : ORDER_NORMAL); // auto always first

		String name = null;
		String number = null;
		if (info != null)
		{
			name = TextUtils.isEmpty(info.getName()) ?
					info.getUsername() : info.getName();
			number = info.getOutgoingNumber();
		}
		
		if (autoConf)
		{
			if (TextUtils.isEmpty(name))
				setTitle(R.string.settings_auto_voipclient);
			else
				setTitle(String.format(context.getString(
						R.string.settings_autoname_voipclient), name));
		}
		else setTitle(name);

		if (!TextUtils.isEmpty(number))
		{
			String summary = String.format(context.getString(
					R.string.settings_voipclient_summary_fmt), number);
			setSummaryOn(summary);
			setSummaryOff(summary);
		}
		setPersistent(false);
		
		setWidgetLayoutResource(R.layout.preference_widget_radio);
	}
}
